C      *****************************************************************
C      * Subroutine NitroCheck                                         *
C      * Checks to see if N, or NO3, or NH4 is present.  If they are   *
C      * not present, a false is returned in the variable AllOK.  If   *
C      * one of them is present then AllOK is returned as true and     *
C      * mineralized N is initialized to N, if it is present, or NH4,  *
C      * if it is present and N is not, or NO3 if it is present and    *
C      * neither N nor NH4 are present.                                *
C      *                                                               *
C      * Variables:                                                    *
C      * AllOK     -Output- Indicates whether a component with nitrogen*
C      *                    has been found (TRUE) or not (FALSE).      *
C      *                    Unitless.                                  *
C      * FileNum   -Input - The output file number for the YASE model. *
C      *                    Unitless.                                  *
C      * Index     -Local - An array that receives the index passed    *
C      *                    back from the function WhereIs.  A -1 means*
C      *                    that the component was not found.          *
C      *                    Unitless.                                  *
C      * KT        -Input - A matrix, of size NComp by NLayer, of the  *
C      *                    known total amount for each component, for *
C      *                    each layer.  The total includes the amount *
C      *                    of the component as a free component and as*
C      *                    part of all dependent species.  Units are  *
C      *                    mol.                                       *
C      *                    (Common block VModel, file VModel.f)       *
C      * L         -Local - Layer number index.  Unitless.             *
C      * Layers    -Input - The number of layers that the inorganic    *
C      *                    nitrogen is to be initialized for.         *
C      *                    Unitless.                                  *
C      * Name      -Local - A component name for passing to function   *
C      *                    WhereIs.  Unitless.                        *
C      * NitInx    -Output- The index number for the component whose   *
C      *                    KT is to be updated by the inorganic       *
C      *                    nitrogen.  Unitless.                       *
C      * Nitro     -Output- An array of initial values for inorganic   *
C      *                    nitrogen for each layer.  Units are mol.   *
C      * WhereIs   -Fcn   - Returns the index of requested species. If *
C      *                    the species is not found a -1 is returned. *
C      *                    Unitless.                                  *
C      *****************************************************************
       SUBROUTINE NITROCHECK(FILENUM, LAYERS, ALLOK, NITRO, NITINX)
       IMPLICIT NONE
       INCLUDE 'VMODEL.INC'
       INTEGER FILENUM, INDEX(3), I, L, LAYERS, NITINX, WHEREIS
       LOGICAL ALLOK
       REAL*8 NITRO(15)
       CHARACTER*8 NAME

C      *--------------------------------------------------------------*
C      * Is N or NH4 or NO3 in the list of components?  If so,        *
C      * continue, if not, exit indicating that nitrogen component    *
C      * does not exist.                                              *
C      *--------------------------------------------------------------*
       NAME = 'N'
       INDEX(1) = WHEREIS(NAME)
       NAME = 'NH4'
       INDEX(2) = WHEREIS(NAME)
       NAME = 'NO3'
       INDEX(3) = WHEREIS(NAME)

C      *-------------------*
C      * Is N a component? *
C      *-------------------*
       IF (INDEX(1).NE.-1) THEN
C         *------------------------------------------------------*
C         * N is a component, indicate that it has been found    *
C         * and set it as the component to be updated with       *
C         * mineralized nitrogen.                                *
C         *------------------------------------------------------*
          ALLOK  = .TRUE.
          NITINX = INDEX(1)
C      *-------------------------------------------*
C      * N is not a component, is NH4 a component? *
C      *-------------------------------------------*
       ELSE IF (INDEX(2).NE.-1) THEN
C         *------------------------------------------------------*
C         * NH4 is a component, indicate that it has been found  *
C         * and set it as the component to be updated with       *
C         * mineralized nitrogen.                                *
C         *------------------------------------------------------*
          ALLOK  = .TRUE.
          NITINX = INDEX(2)
C      *-------------------------------------------------------*
C      * Neither N nor NH4 is a component, is NO3 a component? *
C      *-------------------------------------------------------*
       ELSE IF (INDEX(3).NE.-1) THEN
C         *------------------------------------------------------*
C         * NO3 is a component.  Indicate that it has been found *
C         * and set it as the component to be updated with       *
C         * mineralized nitrogen.                                *
C         *------------------------------------------------------*
          ALLOK  = .TRUE.
          NITINX = INDEX(3)
       ELSE
C         *-------------------------------------------------------------*
C         * Neither N, nor NH4, nor NO3 are components.  Indicate this. *
C         *-------------------------------------------------------------*
          ALLOK = .FALSE.
          WRITE(FILENUM,*) 
          WRITE(FILENUM,*) '***************************************'
          WRITE(FILENUM,*) '* Decomposition has NOT been run      *'
          WRITE(FILENUM,*) '* because neither N, nor NH4, nor NO3 *'
          WRITE(FILENUM,*) '* are components.                     *'
          WRITE(FILENUM,*) '***************************************'
          WRITE(FILENUM,*) 
       ENDIF

C      *-------------------------------------------------------*
C      * If the nitrogen components were found, initialize the *
C      * inorganic nitrogen for each layer to the known total  *
C      * of the nitrogen component for that layer.             *
C      *-------------------------------------------------------*
       IF (ALLOK) THEN
          DO 100 L = 1, LAYERS
             NITRO(L) = KT(NITINX,L)
  100     CONTINUE
       ENDIF

	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
